import java.awt.*;
import java.awt.event.*;

public class WeightControl extends Canvas {


    public WeightControl(Image img) {
	image = img;

	preferredSize = new Dimension(164, 164);	

	buffer = createImage(164, 164);

	target = new Point(82, 82);
	center = new Point(82, 82);

	//	preferredSize = new Dimension(image.getWidth(this), image.getHeight(this));	

	TargetListener listener = new TargetListener();
	addMouseListener(listener);
	addMouseMotionListener(listener);
    }

    public void update(Graphics g) {
	paint(g);
    }

    public void revalidate() {
	Container parent = getParent();
	if (parent != null)
	    parent.validate();
    }

    public void paint(Graphics g) {
	Graphics bufferG;

	//	if (buffer == null)
	//	    buffer = getParent().createImage(preferredSize.width, preferredSize.height);
	//	bufferG = buffer.getGraphics();
	bufferG = g;

	bufferG.drawImage(image, 0, 0, this);

	bufferG.setColor(Color.black);
	bufferG.drawOval(target.x-4, target.y-4, 10, 10);
	bufferG.drawLine(target.x-9, target.y+1, target.x+11, target.y+1);
	bufferG.drawLine(target.x+1, target.y-9, target.x+1, target.y+11);	
	bufferG.setColor(Color.red);
	bufferG.drawOval(target.x-5, target.y-5, 10, 10);
	bufferG.drawLine(target.x-10, target.y, target.x+10, target.y);
	bufferG.drawLine(target.x, target.y-10, target.x, target.y+10);	

	//	g.drawImage(buffer, 0, 0, this);
    }

    public Dimension getPreferredSize() {
	return preferredSize;
    }

    private class TargetListener extends MouseAdapter implements MouseMotionListener {
	public void mousePressed(MouseEvent event) {
	    
	    double dist = pixelDistance(event.getPoint(), center);

	    if (dist < 64) 
		target = event.getPoint();
	    else {
		Point delta = new Point(event.getX() - center.x,
					event.getY() - center.y);
		double fraction = 64/dist;
		target.x = (int)Math.round(center.x+delta.x*fraction);
		target.y = (int)Math.round(center.y+delta.y*fraction);
	    }
	    
	    Boids.TARGET_WEIGHT = 1 - ((double)(target.x - center.x))/64;
	    Boids.ORIENTATION_WEIGHT = 1 + ((double)(target.x - center.x))/64;
	    Boids.DISPERSION_WEIGHT = 1 - ((double)(target.y - center.y))/64;
	    Boids.CLUSTER_WEIGHT = 1 + ((double)(target.y - center.y))/64;
	
	    repaint();
	}

	public void mouseMoved(MouseEvent event) {  
	}

	public void mouseDragged(MouseEvent event) {
	    double dist = pixelDistance(event.getPoint(), center);

	    if (dist < 64) 
		target = event.getPoint();
	    else {
		Point delta = new Point(event.getX() - center.x,
					event.getY() - center.y);
		double fraction = 64/dist;
		target.x = (int)Math.round(center.x+delta.x*fraction);
		target.y = (int)Math.round(center.y+delta.y*fraction);
	    }
	    Boids.TARGET_WEIGHT = 1 - 2*((double)(target.x - center.x))/64;
	    Boids.ORIENTATION_WEIGHT = 1 + 2*((double)(target.x - center.x))/64;
	    Boids.DISPERSION_WEIGHT = 1 - 2*((double)(target.y - center.y))/64;
	    Boids.CLUSTER_WEIGHT = 1 + 2*((double)(target.y - center.y))/64;
	
	    repaint();
	}
    }

    static double pixelDistance(Point a, Point b) {
	return Math.sqrt((b.x - a.x)*(b.x - a.x) + (b.y - a.y)*(b.y - a.y));
    }
       
    private Image image;
    private Image buffer;
    private Dimension preferredSize;
    private Point target, center;
}

