import java.awt.*;

public class Obstacle {

    public Obstacle(int x, int y, double r) {
	center = new DoublePoint(x, y);
	radius = r;
    }

    public double[] intersections(int x1, int y1, int x2, int y2) {

	// From Foley and Van Damme, 2nd Ed. p. 1101

	DoublePoint v = new DoublePoint(x2 - x1, y2 - y1);
	DoublePoint q = new DoublePoint(x1, y1);

	DoublePoint p = center;
	
	DoublePoint qMinusp = new DoublePoint(q.x-p.x, q.y-p.y);

	double a = v.x*v.x + v.y*v.y;
	double b = 2*v.x*qMinusp.x + 2*v.y*qMinusp.y;
	double c = qMinusp.x*qMinusp.x + qMinusp.y*qMinusp.y - radius*radius;

	double t1 = (-b + Math.sqrt(b*b - 4*a*c))/(2*a);
	double t2 = (-b - Math.sqrt(b*b - 4*a*c))/(2*a);
	return new double[] {t1, t2};
    }

    public DoublePoint[] intersectionPoints(int x1, int y1, int x2, int y2) {
	DoublePoint v = new DoublePoint(x2 - x1, y2 - y1);
	double[] intersections = intersections(x1, y1, x2, y2);
	DoublePoint intersect1 = new DoublePoint(x1+intersections[0]*v.x, 
						 y1+intersections[0]*v.y);
	DoublePoint intersect2 = new DoublePoint(x1+intersections[1]*v.x, 
						 y1+intersections[1]*v.y);
	//	System.out.println("t1 = "+intersections[0]+", t2 = "+intersections[1]);

	return new DoublePoint[] {intersect1, intersect2};
    }

    DoublePoint center;
    double radius;

}
