/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class WeightControl
extends Canvas {
    private Image image;
    private Image buffer;
    private Dimension preferredSize;
    private Point target;
    private Point center;

    public WeightControl(Image image) {
        this.image = image;
        this.preferredSize = new Dimension(164, 164);
        this.buffer = this.createImage(164, 164);
        this.target = new Point(82, 82);
        this.center = new Point(82, 82);
        TargetListener targetListener = new TargetListener();
        this.addMouseListener(targetListener);
        this.addMouseMotionListener(targetListener);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void revalidate() {
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics;
        graphics2.drawImage(this.image, 0, 0, this);
        graphics2.setColor(Color.black);
        graphics2.drawOval(this.target.x - 4, this.target.y - 4, 10, 10);
        graphics2.drawLine(this.target.x - 9, this.target.y + 1, this.target.x + 11, this.target.y + 1);
        graphics2.drawLine(this.target.x + 1, this.target.y - 9, this.target.x + 1, this.target.y + 11);
        graphics2.setColor(Color.red);
        graphics2.drawOval(this.target.x - 5, this.target.y - 5, 10, 10);
        graphics2.drawLine(this.target.x - 10, this.target.y, this.target.x + 10, this.target.y);
        graphics2.drawLine(this.target.x, this.target.y - 10, this.target.x, this.target.y + 10);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    static double pixelDistance(Point point, Point point2) {
        return Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y));
    }

    private class TargetListener
    extends MouseAdapter
    implements MouseMotionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            double d = WeightControl.pixelDistance(mouseEvent.getPoint(), WeightControl.this.center);
            if (d < 64.0) {
                WeightControl.this.target = mouseEvent.getPoint();
            } else {
                Point point = new Point(mouseEvent.getX() - ((WeightControl)WeightControl.this).center.x, mouseEvent.getY() - ((WeightControl)WeightControl.this).center.y);
                double d2 = 64.0 / d;
                ((WeightControl)WeightControl.this).target.x = (int)Math.round((double)((WeightControl)WeightControl.this).center.x + (double)point.x * d2);
                ((WeightControl)WeightControl.this).target.y = (int)Math.round((double)((WeightControl)WeightControl.this).center.y + (double)point.y * d2);
            }
            Boids.TARGET_WEIGHT = 1.0 - (double)(((WeightControl)WeightControl.this).target.x - ((WeightControl)WeightControl.this).center.x) / 64.0;
            Boids.ORIENTATION_WEIGHT = 1.0 + (double)(((WeightControl)WeightControl.this).target.x - ((WeightControl)WeightControl.this).center.x) / 64.0;
            Boids.DISPERSION_WEIGHT = 1.0 - (double)(((WeightControl)WeightControl.this).target.y - ((WeightControl)WeightControl.this).center.y) / 64.0;
            Boids.CLUSTER_WEIGHT = 1.0 + (double)(((WeightControl)WeightControl.this).target.y - ((WeightControl)WeightControl.this).center.y) / 64.0;
            WeightControl.this.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            double d = WeightControl.pixelDistance(mouseEvent.getPoint(), WeightControl.this.center);
            if (d < 64.0) {
                WeightControl.this.target = mouseEvent.getPoint();
            } else {
                Point point = new Point(mouseEvent.getX() - ((WeightControl)WeightControl.this).center.x, mouseEvent.getY() - ((WeightControl)WeightControl.this).center.y);
                double d2 = 64.0 / d;
                ((WeightControl)WeightControl.this).target.x = (int)Math.round((double)((WeightControl)WeightControl.this).center.x + (double)point.x * d2);
                ((WeightControl)WeightControl.this).target.y = (int)Math.round((double)((WeightControl)WeightControl.this).center.y + (double)point.y * d2);
            }
            Boids.TARGET_WEIGHT = 1.0 - 2.0 * (double)(((WeightControl)WeightControl.this).target.x - ((WeightControl)WeightControl.this).center.x) / 64.0;
            Boids.ORIENTATION_WEIGHT = 1.0 + 2.0 * (double)(((WeightControl)WeightControl.this).target.x - ((WeightControl)WeightControl.this).center.x) / 64.0;
            Boids.DISPERSION_WEIGHT = 1.0 - 2.0 * (double)(((WeightControl)WeightControl.this).target.y - ((WeightControl)WeightControl.this).center.y) / 64.0;
            Boids.CLUSTER_WEIGHT = 1.0 + 2.0 * (double)(((WeightControl)WeightControl.this).target.y - ((WeightControl)WeightControl.this).center.y) / 64.0;
            WeightControl.this.repaint();
        }

        TargetListener() {
            WeightControl.this = WeightControl.this;
        }
    }
}

