/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Random;
import java.util.Vector;

public class Boids
extends Canvas {
    Point target = new Point();
    Vector obstacles = new Vector();
    double maxAcceleration = 2.0;
    double maxVelocity = 10.0;
    Point[] position;
    DoublePoint[] acceleration;
    DoublePoint[] velocity;
    DoublePoint[] orientation;
    Polygon[] shape;
    WeightControl weightControl;
    Image buffer;
    int BOID_COUNT = 50;
    Dimension SIZE = new Dimension(320, 400);
    int OBSTACLE_CUTOFF_RADIUS = 50;
    static double TARGET_WEIGHT = 1.0;
    static double CLUSTER_WEIGHT = 1.0;
    static double DISPERSION_WEIGHT = 1.0;
    static double OBSTACLE_WEIGHT = 5.0;
    static double ORIENTATION_WEIGHT = 1.0;
    static final float[] shapex = new float[]{-1.0f, -1.5f, 1.0f, -1.5f};
    static final float[] shapey;

    public Boids(int n, int n2, Image image) {
        this.SIZE = new Dimension(n, n2);
        this.weightControl = new WeightControl(image);
        this.buffer = this.createImage(n, n2);
        this.initBoids();
        this.target.y = 100;
        this.target.x = 100;
        BoidsMouseListener boidsMouseListener = new BoidsMouseListener();
        this.addMouseListener(boidsMouseListener);
        this.addMouseMotionListener(boidsMouseListener);
    }

    public synchronized void setTarget(Point point) {
        this.target = point;
    }

    public void calculateAcceleration(DoublePoint doublePoint, int n) {
        DoublePoint doublePoint2 = new DoublePoint();
        doublePoint2.x = this.target.x - this.position[n].x;
        doublePoint2.y = this.target.y - this.position[n].y;
        Boids.normalizeVector(doublePoint2);
        Boids.lengthenVector(doublePoint2, this.maxAcceleration);
        DoublePoint[] doublePointArray = new DoublePoint[this.BOID_COUNT];
        DoublePoint[] doublePointArray2 = new DoublePoint[this.BOID_COUNT];
        double[] dArray = new double[this.BOID_COUNT];
        double d = 2.147483647E9;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.position.length) {
            doublePointArray[n3] = new DoublePoint();
            doublePointArray2[n3] = new DoublePoint();
            doublePointArray[n3].x = doublePointArray2[n3].x = (double)(this.position[n3].x - this.position[n].x);
            doublePointArray[n3].y = doublePointArray2[n3].y = (double)(this.position[n3].y - this.position[n].y);
            dArray[n3] = Boids.vectorLength(doublePointArray[n3]);
            if (dArray[n3] < d && n3 != n) {
                n2 = n3;
                d = dArray[n3];
            }
            Boids.normalizeVector(doublePointArray2[n3]);
            ++n3;
        }
        DoublePoint doublePoint3 = new DoublePoint();
        double d2 = 50.0;
        int n4 = 0;
        while (n4 < this.position.length) {
            if (dArray[n4] < d2) {
                doublePoint3.x += this.maxAcceleration * doublePointArray2[n4].x;
                doublePoint3.y += this.maxAcceleration * doublePointArray2[n4].y;
            }
            ++n4;
        }
        Boids.truncateVector(doublePoint3, this.maxAcceleration);
        DoublePoint doublePoint4 = new DoublePoint();
        double d3 = 20.0;
        int n5 = 0;
        while (n5 < this.position.length) {
            if (dArray[n5] < d3 && dArray[n5] > 0.0) {
                doublePoint4.x -= this.maxAcceleration * doublePointArray2[n5].x * (d3 - dArray[n5]) * (d3 - dArray[n5]);
                doublePoint4.y -= this.maxAcceleration * doublePointArray2[n5].y * (d3 - dArray[n5]) * (d3 - dArray[n5]);
                doublePoint2.x = 0.0;
                doublePoint3.x = 0.0;
                doublePoint2.y = 0.0;
                doublePoint3.y = 0.0;
            }
            ++n5;
        }
        Boids.truncateVector(doublePoint4, this.maxAcceleration);
        double d4 = 100.0;
        DoublePoint doublePoint5 = new DoublePoint(this.orientation[n].x, this.orientation[n].y);
        DoublePoint doublePoint6 = new DoublePoint();
        DoublePoint doublePoint7 = new DoublePoint();
        Boids.lengthenVector(doublePoint5, d4);
        int n6 = 0;
        while (n6 < this.obstacles.size()) {
            Obstacle obstacle = (Obstacle)this.obstacles.elementAt(n6);
            double[] dArray2 = obstacle.intersections(this.position[n].x, this.position[n].y, (int)Math.round((double)this.position[n].x + doublePoint5.x), (int)Math.round((double)this.position[n].y + doublePoint5.y));
            if (Math.abs(dArray2[0]) <= 1.0 || Math.abs(dArray2[1]) <= 1.0) {
                doublePoint7.x = obstacle.center.x - (double)this.position[n].x;
                doublePoint7.y = obstacle.center.y - (double)this.position[n].y;
                Boids.normalizeVector(doublePoint7);
                doublePoint6.x -= this.maxAcceleration * doublePoint7.x;
                doublePoint6.y -= this.maxAcceleration * doublePoint7.y;
            }
            ++n6;
        }
        DoublePoint doublePoint8 = new DoublePoint();
        double d5 = 20.0;
        int n7 = 0;
        while (n7 < this.orientation.length) {
            if (dArray[n7] < d5) {
                doublePoint8.x += this.orientation[n7].x;
                doublePoint8.y += this.orientation[n7].y;
            }
            ++n7;
        }
        Boids.normalizeVector(doublePoint8);
        Boids.lengthenVector(doublePoint8, this.maxAcceleration);
        doublePoint.y = 0.0;
        doublePoint.x = 0.0;
        doublePoint.x += TARGET_WEIGHT * doublePoint2.x;
        doublePoint.y += TARGET_WEIGHT * doublePoint2.y;
        doublePoint.x += CLUSTER_WEIGHT * doublePoint3.x;
        doublePoint.y += CLUSTER_WEIGHT * doublePoint3.y;
        doublePoint.x += DISPERSION_WEIGHT * doublePoint4.x;
        doublePoint.y += DISPERSION_WEIGHT * doublePoint4.y;
        doublePoint.x += OBSTACLE_WEIGHT * doublePoint6.x;
        doublePoint.y += OBSTACLE_WEIGHT * doublePoint6.y;
        doublePoint.x += ORIENTATION_WEIGHT * doublePoint8.x;
        doublePoint.y += ORIENTATION_WEIGHT * doublePoint8.y;
    }

    public synchronized void step() {
        int n = 0;
        while (n < this.BOID_COUNT) {
            this.position[n].x = (int)((long)this.position[n].x + Math.round(this.velocity[n].x));
            this.position[n].y = (int)((long)this.position[n].y + Math.round(this.velocity[n].y));
            if (this.position[n].x < 0) {
                this.position[n].x += this.SIZE.width;
            } else if (this.position[n].x > this.SIZE.width) {
                this.position[n].x %= this.SIZE.width;
            }
            if (this.position[n].y < 0) {
                this.position[n].y += this.SIZE.height;
            } else if (this.position[n].y > this.SIZE.height) {
                this.position[n].y %= this.SIZE.height;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.BOID_COUNT) {
            this.calculateAcceleration(this.acceleration[n2], n2);
            Boids.truncateVector(this.acceleration[n2], this.maxAcceleration);
            Boids.lengthenVector(this.acceleration[n2], this.maxAcceleration);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.BOID_COUNT) {
            this.velocity[n3].x = this.orientation[n3].x = this.velocity[n3].x + this.acceleration[n3].x;
            this.velocity[n3].y = this.orientation[n3].y = this.velocity[n3].y + this.acceleration[n3].y;
            Boids.normalizeVector(this.orientation[n3]);
            Boids.truncateVector(this.velocity[n3], this.maxVelocity);
            Rectangle rectangle = null;
            if (this.shape != null) {
                rectangle = this.shape[n3].getBounds();
            }
            this.recalculateShape(n3);
            rectangle = rectangle != null ? rectangle.union(this.shape[n3].getBounds()) : this.shape[n3].getBounds();
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.obstacles.size()) {
            Obstacle obstacle = (Obstacle)this.obstacles.elementAt(n4);
            if (obstacle.radius < (double)this.OBSTACLE_CUTOFF_RADIUS) {
                obstacle.radius += 1.0;
            }
            ++n4;
        }
        this.repaint();
    }

    private void recalculateShape(int n) {
        int n2 = 0;
        while (n2 < shapex.length) {
            double d = 5.0 * ((double)shapex[n2] * this.orientation[n].x - (double)shapey[n2] * this.orientation[n].y);
            double d2 = 5.0 * ((double)shapex[n2] * this.orientation[n].y + (double)shapey[n2] * this.orientation[n].x);
            this.shape[n].xpoints[n2] = (int)Math.round(d);
            this.shape[n].ypoints[n2] = (int)Math.round(d2);
            ++n2;
        }
        this.shape[n].translate(this.position[n].x, this.position[n].y);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.buffer == null) {
            this.buffer = this.getParent().createImage(this.SIZE.width, this.SIZE.height);
        }
        Graphics graphics2 = this.buffer.getGraphics();
        Rectangle rectangle = this.getBounds();
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, this.SIZE.width, this.SIZE.height);
        int n = 0;
        while (n < this.shape.length) {
            if (this.shape[n] != null) {
                graphics2.setColor(Color.red);
                graphics2.fillPolygon(this.shape[n]);
                graphics2.setColor(Color.black);
                graphics2.drawPolygon(this.shape[n]);
            }
            ++n;
        }
        graphics2.setColor(Color.green);
        graphics2.drawLine(this.target.x - 10, this.target.y, this.target.x + 10, this.target.y);
        graphics2.drawLine(this.target.x, this.target.y - 10, this.target.x, this.target.y + 10);
        graphics2.setColor(Color.black);
        graphics2.drawLine(this.target.x - 9, this.target.y + 1, this.target.x + 11, this.target.y + 1);
        graphics2.drawLine(this.target.x + 1, this.target.y - 9, this.target.x + 1, this.target.y + 11);
        Serializable serializable = this;
        synchronized (serializable) {
            graphics2.setColor(Color.blue);
            int n2 = 0;
            while (n2 < this.obstacles.size()) {
                Obstacle obstacle = (Obstacle)this.obstacles.elementAt(n2);
                graphics2.drawOval((int)Math.round(obstacle.center.x - obstacle.radius), (int)Math.round(obstacle.center.y - obstacle.radius), (int)Math.round(2.0 * obstacle.radius), (int)Math.round(2.0 * obstacle.radius));
                ++n2;
            }
        }
        serializable = this.weightControl.getPreferredSize();
        Point point = new Point(rectangle.width - ((Dimension)serializable).width, rectangle.height - ((Dimension)serializable).height);
        graphics2.translate(point.x, point.y);
        this.weightControl.paint(graphics2);
        graphics2.translate(-point.x, -point.y);
        graphics2.setColor(Color.black);
        graphics2.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    public Dimension getPreferredSize() {
        return this.SIZE;
    }

    void initBoids() {
        this.acceleration = new DoublePoint[this.BOID_COUNT];
        this.velocity = new DoublePoint[this.BOID_COUNT];
        this.orientation = new DoublePoint[this.BOID_COUNT];
        this.shape = new Polygon[this.BOID_COUNT];
        this.position = new Point[this.BOID_COUNT];
        Random random = new Random();
        int n = 0;
        while (n < this.BOID_COUNT) {
            this.acceleration[n] = new DoublePoint();
            this.velocity[n] = new DoublePoint();
            this.velocity[n].x = Math.round(((double)random.nextFloat() - 0.5) * this.maxVelocity * 2.0);
            this.velocity[n].y = Math.round(((double)random.nextFloat() - 0.5) * this.maxVelocity * 2.0);
            Boids.truncateVector(this.velocity[n], this.maxVelocity);
            this.orientation[n] = new DoublePoint();
            this.orientation[n].x = this.velocity[n].x;
            this.orientation[n].y = this.velocity[n].y;
            Boids.normalizeVector(this.orientation[n]);
            this.shape[n] = new Polygon();
            int n2 = 0;
            while (n2 < shapex.length) {
                this.shape[n].addPoint(0, 0);
                ++n2;
            }
            this.position[n] = new Point();
            this.position[n].x = Math.round(random.nextFloat() * (float)this.SIZE.width);
            this.position[n].y = Math.round(random.nextFloat() * (float)this.SIZE.height);
            ++n;
        }
    }

    static double pixelDistance(Point point, Point point2) {
        return Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y));
    }

    static double vectorLength(DoublePoint doublePoint) {
        return Math.sqrt(doublePoint.x * doublePoint.x + doublePoint.y * doublePoint.y);
    }

    static double vectorLengthSquared(DoublePoint doublePoint) {
        return doublePoint.x * doublePoint.x + doublePoint.y * doublePoint.y;
    }

    static void normalizeVector(DoublePoint doublePoint) {
        double d = Boids.vectorLength(doublePoint);
        if (d == 0.0) {
            return;
        }
        doublePoint.x /= d;
        doublePoint.y /= d;
    }

    static void truncateVector(DoublePoint doublePoint, double d) {
        if (Boids.vectorLengthSquared(doublePoint) > d * d) {
            Boids.normalizeVector(doublePoint);
            doublePoint.x *= d;
            doublePoint.y *= d;
        }
    }

    static void lengthenVector(DoublePoint doublePoint, double d) {
        double d2 = Boids.vectorLength(doublePoint);
        if (d2 == 0.0) {
            return;
        }
        double d3 = (d2 + d) / d2;
        doublePoint.x *= d3;
        doublePoint.y *= d3;
    }

    static void divideVector(DoublePoint doublePoint, double d) {
        doublePoint.x /= d;
        doublePoint.y /= d;
    }

    static {
        float[] fArray = new float[4];
        fArray[1] = -1.0f;
        fArray[3] = 1.0f;
        shapey = fArray;
    }

    private class BoidsMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private int mousePressedModifiers;

        public void mousePressed(MouseEvent mouseEvent) {
            this.mousePressedModifiers = mouseEvent.getModifiers();
            if (this.eventShouldBeDispatched(mouseEvent)) {
                this.forwardEvent(mouseEvent);
                return;
            }
            if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    Boids.this.obstacles.addElement(new Obstacle(mouseEvent.getX(), mouseEvent.getY(), 1.0));
                    return;
                }
                Boids.this.setTarget(mouseEvent.getPoint());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.eventShouldBeDispatched(mouseEvent)) {
                this.forwardEvent(mouseEvent);
                return;
            }
            if ((this.mousePressedModifiers & 0x10) != 0 && !mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                Boids.this.setTarget(mouseEvent.getPoint());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private boolean eventShouldBeDispatched(MouseEvent mouseEvent) {
            Rectangle rectangle = Boids.this.getBounds();
            Dimension dimension = Boids.this.weightControl.getPreferredSize();
            return mouseEvent.getX() > rectangle.width - dimension.width && mouseEvent.getY() > rectangle.height - dimension.height;
        }

        private void forwardEvent(MouseEvent mouseEvent) {
            Rectangle rectangle = Boids.this.getBounds();
            Dimension dimension = Boids.this.weightControl.getPreferredSize();
            Point point = new Point(rectangle.width - dimension.width, rectangle.height - dimension.height);
            mouseEvent.translatePoint(-point.x, -point.y);
            Boids.this.weightControl.dispatchEvent(mouseEvent);
        }

        BoidsMouseListener() {
            Boids.this = Boids.this;
        }
    }
}

